Rem
Rem $Header: mq_adm_cleanup.sql 17-jan-2007.13:00:38 chall Exp $
Rem
Rem mq_adm_cleanup.sql
Rem
Rem Copyright (c) 2003, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      mq_adm_cleanup.sql - Removes the Messaging Gateway configuration.
Rem
Rem    DESCRIPTION
Rem      Script to remove Messaging Gateway configured objects used in
Rem      this sample.
Rem
Rem    NOTES
Rem      WARNING!! This script should be run when the Messaging Gateway 
Rem      agent is running. If the agent is not running, the propagation 
Rem      jobs will not be fully removed until the agent is restarted.
Rem
Rem      The order of removing MGW objects is important. A link cannot be 
Rem      removed until all associated foreign queues have been unregistered.
Rem      A foreign queue cannot be unregistered when propagation jobs, 
Rem      subscribers or schedules reference it.
Rem

connect mgwadm/mgwadm

Rem Remove the propagation jobs.

begin
  -- Since this job was for outbound propagation removing it will 
  -- also remove the underlying AQ subscriber.
  dbms_mgwadm.remove_job(job_name => 'job_aq2mq',
                         force    => dbms_mgwadm.NO_FORCE);
end;
/

begin
  dbms_mgwadm.remove_job(job_name => 'job_mq2aq',
                         force    => dbms_mgwadm.NO_FORCE);
end;
/

Rem Unregister the MQSeries queue.

begin
  dbms_mgwadm.unregister_foreign_queue(name => 'destq', linkname => 'mqlink');
end;
/

Rem Finally, remove the link.

begin 
  dbms_mgwadm.remove_msgsystem_link('mqlink');
end;
/
